{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:40:07 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, MMObj, MMSlider, ComCtrls,
  MMDSPObj, MMWave, MMPanel, MMDIBCv, MMLevel, MMSpectr, MMScroll, MMLEDS,
  MMLEDLbl;

type
  TMainForm = class(TForm)
    MMSlider1: TMMSlider;
    MMSlider2: TMMSlider;
    MMSlider3: TMMSlider;
    MMSlider4: TMMSlider;
    MMSlider5: TMMSlider;
    MMSlider6: TMMSlider;
    MMSlider7: TMMSlider;
    MMSlider8: TMMSlider;
    MMSlider9: TMMSlider;
    MMSlider10: TMMSlider;
    MMSlider11: TMMSlider;
    MMSlider12: TMMSlider;
    MMSlider13: TMMSlider;
    MMSlider14: TMMSlider;
    MMSlider15: TMMSlider;
    MMSlider16: TMMSlider;
    MMSlider17: TMMSlider;
    Button1: TButton;
    procedure SliderDrawThumb(Sender: TObject; aCanvas: TCanvas;
                                aRect: TRect; Dragged,Focused: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
  public
    ThumbMode: integer;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   Application.OnMessage := AppMessage;
   ThumbMode := 0;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.AppMessage(var Msg: TMsg; var Handled: Boolean);
begin
  with Msg do
  if Active and (Message = WM_MOUSEMOVE) then
  begin
     if FindControl(Msg.HWND) is TMMSlider then
     begin
        Windows.SetFocus(Msg.HWND);
     end;
  end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SliderDrawThumb(Sender: TObject; aCanvas: TCanvas;
                                   aRect: TRect; Dragged,Focused: Boolean);
begin
   with Sender as TMMSlider, aCanvas do
   begin
      if (ThumbMode = 1) then
      begin
         Frame3D(aCanvas, aRect, clBtnHighlight, clWindowFrame, 1);

         if not Enabled then
         begin
            Brush.Color := DisabledColor;
            Pen.Color := DisabledColor;
         end
         else
         begin
            Brush.Color := ThumbColor;
            Pen.Color := ThumbColor;
         end;
         Frame3D(aCanvas, aRect, Pen.Color, clBtnShadow, 1);
         FillRect(aRect);

         InflateRect(aRect, -2, -2);
         Frame3D(aCanvas, aRect, clBtnShadow, clBtnHighLight, 1);
         if Dragged then
            Brush.Color := clRed
         else
            Brush.Color := clMaroon;
         FillRect(aRect);
      end
      else if (ThumbMode = 2) then
      begin
         Pen.Color := clBlack;
         MoveTo(aRect.Left+1,aRect.Top);
         LineTo(aRect.Right-1,aRect.Top);
         MoveTo(aRect.Left,aRect.Top+1);
         LineTo(aRect.Left,aRect.Bottom-1);
         MoveTo(aRect.Right-1,aRect.Top+1);
         LineTo(aRect.Right-1,aRect.Bottom-1);
         MoveTo(aRect.Left+1,aRect.Bottom-1);
         LineTo(aRect.Right-1,aRect.Bottom-1);

         InflateRect(aRect,-1,-1);
         Frame3D(aCanvas, aRect, clBtnHighlight, clBtnShadow, 1);

         Brush.Color := ThumbColor;
         FillRect(aRect);

         Pen.Color := clGray;
         MoveTo(aRect.Left+2,aRect.Top+2);
         LineTo(aRect.Right-2,aRect.Top+2);
         Pen.Color := clWhite;
         MoveTo(aRect.Left+2,aRect.Top+3);
         LineTo(aRect.Right-2,aRect.Top+3);

         Pen.Color := clGray;
         MoveTo(aRect.Left+3,aRect.Top+(aRect.Bottom-aRect.Top)div 2-1);
         LineTo(aRect.Right-3,aRect.Top+(aRect.Bottom-aRect.Top)div 2-1);
         Pen.Color := clWhite;
         MoveTo(aRect.Left+3,aRect.Top+(aRect.Bottom-aRect.Top)div 2);
         LineTo(aRect.Right-3,aRect.Top+(aRect.Bottom-aRect.Top)div 2);

         Pen.Color := clGray;
         MoveTo(aRect.Left+2,aRect.Bottom-4);
         LineTo(aRect.Right-2,aRect.Bottom-4);
         Pen.Color := clWhite;
         MoveTo(aRect.Left+2,aRect.Bottom-3);
         LineTo(aRect.Right-2,aRect.Bottom-3);
      end;
   end;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
   i: integer;
begin
   inc(ThumbMode);
   if ThumbMode > 2 then ThumbMode := 0;

   for i := 0 to ComponentCount-1 do
   begin
      if (Components[i] is TMMSlider) then
      with (Components[i] as TMMSlider) do
      begin
         if (ThumbMode = 0) then
         begin
            ThumbStyle := tsRect;
            ThumbWidth := 23;
            ThumbHeight := 11;
         end
         else if (ThumbMode = 1) then
         begin
            ThumbStyle := tsOwnerDraw;
            ThumbWidth := 23;
            ThumbHeight := 11;
         end
         else if (ThumbMode = 2) then
         begin
            ThumbStyle := tsOwnerDraw;
            ThumbWidth := 15;
            ThumbHeight := 18;
         end;
      end;
   end;
end;

end.
